/*
 * Decompiled with CFR 0.152.
 */
package de.johni0702.minecraft.bobby;

import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import de.johni0702.minecraft.bobby.Bobby;
import de.johni0702.minecraft.bobby.BobbyConfig;
import de.johni0702.minecraft.bobby.FakeChunk;
import de.johni0702.minecraft.bobby.LastAccessFile;
import de.johni0702.minecraft.bobby.ext.ChunkLightProviderExt;
import io.netty.util.concurrent.DefaultThreadFactory;
import it.unimi.dsi.fastutil.longs.LongListIterator;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.class_155;
import net.minecraft.class_156;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_1944;
import net.minecraft.class_1972;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2359;
import net.minecraft.class_2378;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2501;
import net.minecraft.class_2509;
import net.minecraft.class_2520;
import net.minecraft.class_2556;
import net.minecraft.class_2561;
import net.minecraft.class_2588;
import net.minecraft.class_2680;
import net.minecraft.class_2791;
import net.minecraft.class_2802;
import net.minecraft.class_2804;
import net.minecraft.class_2818;
import net.minecraft.class_2826;
import net.minecraft.class_2841;
import net.minecraft.class_2897;
import net.minecraft.class_2902;
import net.minecraft.class_310;
import net.minecraft.class_3568;
import net.minecraft.class_3977;
import net.minecraft.class_4076;
import net.minecraft.class_4698;
import net.minecraft.class_5321;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public class FakeChunkStorage
extends class_3977 {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Map<Path, FakeChunkStorage> active = new HashMap<Path, FakeChunkStorage>();
    public static final Pattern REGION_FILE_PATTERN = Pattern.compile("^r\\.(-?[0-9]+)\\.(-?[0-9]+)\\.mca$");
    private static final class_2804 COMPLETELY_DARK = new class_2804();
    private static final class_2804 COMPLETELY_LIT = new class_2804();
    private static final Codec<class_2841<class_2680>> BLOCK_CODEC;
    private final Path directory;
    private final AtomicBoolean sentUpgradeNotification = new AtomicBoolean();
    @Nullable
    private final LastAccessFile lastAccess;

    public static FakeChunkStorage getFor(Path directory, boolean cleanupOnClose) {
        if (!class_310.method_1551().method_18854()) {
            throw new IllegalStateException("Must be called from main thread.");
        }
        return active.computeIfAbsent(directory, f -> new FakeChunkStorage(directory, cleanupOnClose));
    }

    public static void closeAll() {
        for (FakeChunkStorage storage : active.values()) {
            try {
                storage.close();
            }
            catch (IOException e) {
                LOGGER.error("Failed to close storage", (Throwable)e);
            }
        }
        active.clear();
    }

    private FakeChunkStorage(Path directory, boolean cleanupOnClose) {
        super(directory, class_310.method_1551().method_1543(), false);
        this.directory = directory;
        LastAccessFile lastAccess = null;
        if (cleanupOnClose) {
            try {
                Files.createDirectories(directory, new FileAttribute[0]);
                lastAccess = new LastAccessFile(directory);
            }
            catch (IOException e) {
                LOGGER.error("Failed to read last_access file:", (Throwable)e);
            }
        }
        this.lastAccess = lastAccess;
    }

    public void close() throws IOException {
        super.close();
        if (this.lastAccess != null) {
            int deleteUnusedRegionsAfterDays = Bobby.getInstance().getConfig().getDeleteUnusedRegionsAfterDays();
            if (deleteUnusedRegionsAfterDays >= 0) {
                LongListIterator longListIterator = this.lastAccess.pollRegionsOlderThan(deleteUnusedRegionsAfterDays).iterator();
                while (longListIterator.hasNext()) {
                    long entry = (Long)longListIterator.next();
                    int x = class_1923.method_8325((long)entry);
                    int z = class_1923.method_8332((long)entry);
                    Files.deleteIfExists(this.directory.resolve("r." + x + "." + z + ".mca"));
                }
            }
            this.lastAccess.close();
        }
    }

    public void save(class_1923 pos, class_2487 chunk) {
        if (this.lastAccess != null) {
            this.lastAccess.touchRegion(pos.method_17885(), pos.method_17886());
        }
        this.method_17910(pos, chunk);
    }

    @Nullable
    public class_2487 loadTag(class_1923 pos) throws IOException {
        class_2487 nbt = this.method_23696(pos);
        if (nbt != null && this.lastAccess != null) {
            this.lastAccess.touchRegion(pos.method_17885(), pos.method_17886());
        }
        if (nbt != null && nbt.method_10550("DataVersion") != class_155.method_16673().method_37912().method_38494()) {
            if (this.sentUpgradeNotification.compareAndSet(false, true)) {
                class_310 client = class_310.method_1551();
                client.method_20493(() -> {
                    class_2588 text = new class_2588("bobby.upgrade.required");
                    client.method_20493(() -> client.field_1705.method_1755(class_2556.field_11735, (class_2561)text, class_156.field_25140));
                });
            }
            return null;
        }
        return nbt;
    }

    public class_2487 serialize(class_2818 chunk, class_3568 lightingProvider) {
        class_2378 biomeRegistry = chunk.method_12200().method_30349().method_30530(class_2378.field_25114);
        Codec biomeCodec = class_2841.method_38298((class_2359)biomeRegistry.method_40295(), (Codec)biomeRegistry.method_40294(), (class_2841.class_6563)class_2841.class_6563.field_34570, (Object)biomeRegistry.method_40290(class_1972.field_9451));
        class_1923 chunkPos = chunk.method_12004();
        class_2487 level = new class_2487();
        level.method_10569("DataVersion", class_155.method_16673().method_37912().method_38494());
        level.method_10569("xPos", chunkPos.field_9181);
        level.method_10569("yPos", chunk.method_32891());
        level.method_10569("zPos", chunkPos.field_9180);
        class_2826[] chunkSections = chunk.method_12006();
        class_2499 sectionsTag = new class_2499();
        for (int y = lightingProvider.method_31929(); y < lightingProvider.method_31930(); ++y) {
            class_2804 skyLight;
            class_2804 blockLight;
            class_2826 chunkSection;
            boolean empty = true;
            class_2487 sectionTag = new class_2487();
            sectionTag.method_10567("Y", (byte)y);
            int i = chunk.method_31603(y);
            class_2826 class_28262 = chunkSection = i >= 0 && i < chunkSections.length ? chunkSections[i] : null;
            if (chunkSection != null) {
                sectionTag.method_10566("block_states", (class_2520)BLOCK_CODEC.encodeStart((DynamicOps)class_2509.field_11560, (Object)chunkSection.method_12265()).getOrThrow(false, arg_0 -> ((Logger)LOGGER).error(arg_0)));
                sectionTag.method_10566("biomes", (class_2520)biomeCodec.encodeStart((DynamicOps)class_2509.field_11560, (Object)chunkSection.method_38294()).getOrThrow(false, arg_0 -> ((Logger)LOGGER).error(arg_0)));
                empty = false;
            }
            if ((blockLight = lightingProvider.method_15562(class_1944.field_9282).method_15544(class_4076.method_18681((class_1923)chunkPos, (int)y))) != null && !blockLight.method_12146()) {
                sectionTag.method_10570("BlockLight", blockLight.method_12137());
                empty = false;
            }
            if ((skyLight = lightingProvider.method_15562(class_1944.field_9284).method_15544(class_4076.method_18681((class_1923)chunkPos, (int)y))) != null && !skyLight.method_12146()) {
                sectionTag.method_10570("SkyLight", skyLight.method_12137());
                empty = false;
            }
            if (empty) continue;
            sectionsTag.add((Object)sectionTag);
        }
        level.method_10566("sections", (class_2520)sectionsTag);
        class_2499 blockEntitiesTag = new class_2499();
        for (class_2338 pos : chunk.method_12021()) {
            class_2487 blockEntityTag = chunk.method_20598(pos);
            if (blockEntityTag == null) continue;
            blockEntitiesTag.add((Object)blockEntityTag);
        }
        level.method_10566("block_entities", (class_2520)blockEntitiesTag);
        class_2487 hightmapsTag = new class_2487();
        for (Map.Entry entry : chunk.method_12011()) {
            if (!chunk.method_12009().method_12160().contains(entry.getKey())) continue;
            hightmapsTag.method_10566(((class_2902.class_2903)entry.getKey()).method_12605(), (class_2520)new class_2501(((class_2902)entry.getValue()).method_12598()));
        }
        level.method_10566("Heightmaps", (class_2520)hightmapsTag);
        return level;
    }

    @Nullable
    public Supplier<class_2818> deserialize(class_1923 pos, class_2487 level, class_1937 world) {
        int y;
        BobbyConfig config = Bobby.getInstance().getConfig();
        class_1923 chunkPos = new class_1923(level.method_10550("xPos"), level.method_10550("zPos"));
        if (!Objects.equals(pos, chunkPos)) {
            LOGGER.error("Chunk file at {} is in the wrong location; relocating. (Expected {}, got {})", (Object)pos, (Object)pos, (Object)chunkPos);
        }
        class_2378 biomeRegistry = world.method_30349().method_30530(class_2378.field_25114);
        Codec biomeCodec = class_2841.method_38298((class_2359)biomeRegistry.method_40295(), (Codec)biomeRegistry.method_40294(), (class_2841.class_6563)class_2841.class_6563.field_34570, (Object)biomeRegistry.method_40290(class_1972.field_9451));
        class_2499 sectionsTag = level.method_10554("sections", 10);
        class_2826[] chunkSections = new class_2826[world.method_32890()];
        Object[] blockLight = new class_2804[chunkSections.length + 2];
        class_2804[] skyLight = new class_2804[chunkSections.length + 2];
        Arrays.fill(blockLight, COMPLETELY_DARK);
        for (int i = 0; i < sectionsTag.size(); ++i) {
            class_2487 sectionTag = sectionsTag.method_10602(i);
            y = sectionTag.method_10571("Y");
            int yIndex = world.method_31603(y);
            if (yIndex < -1 || yIndex > chunkSections.length) continue;
            if (yIndex >= 0 && yIndex < chunkSections.length) {
                class_2841 blocks = sectionTag.method_10573("block_states", 10) ? (class_2841)BLOCK_CODEC.parse((DynamicOps)class_2509.field_11560, (Object)sectionTag.method_10562("block_states")).promotePartial(errorMessage -> FakeChunkStorage.logRecoverableError(chunkPos, y, errorMessage)).getOrThrow(false, arg_0 -> ((Logger)LOGGER).error(arg_0)) : new class_2841((class_2359)class_2248.field_10651, (Object)class_2246.field_10124.method_9564(), class_2841.class_6563.field_34569);
                class_2841 biomes = sectionTag.method_10573("biomes", 10) ? (class_2841)biomeCodec.parse((DynamicOps)class_2509.field_11560, (Object)sectionTag.method_10562("biomes")).promotePartial(errorMessage -> FakeChunkStorage.logRecoverableError(chunkPos, y, errorMessage)).getOrThrow(false, arg_0 -> ((Logger)LOGGER).error(arg_0)) : new class_2841(biomeRegistry.method_40295(), (Object)biomeRegistry.method_40290(class_1972.field_9451), class_2841.class_6563.field_34570);
                class_2826 chunkSection = new class_2826(y, blocks, biomes);
                chunkSection.method_12253();
                if (!chunkSection.method_38292()) {
                    chunkSections[yIndex] = chunkSection;
                }
            }
            if (sectionTag.method_10573("BlockLight", 7)) {
                blockLight[yIndex + 1] = new class_2804(sectionTag.method_10547("BlockLight"));
            }
            if (!sectionTag.method_10573("SkyLight", 7)) continue;
            skyLight[yIndex + 1] = new class_2804(sectionTag.method_10547("SkyLight"));
        }
        class_2804 fullSectionAbove = null;
        class_2804 inferredSection = COMPLETELY_LIT;
        for (y = skyLight.length - 1; y >= 0; --y) {
            class_2804 section = skyLight[y];
            if (section != null) {
                inferredSection = null;
                fullSectionAbove = section;
                continue;
            }
            if (inferredSection == null) {
                assert (fullSectionAbove != null);
                inferredSection = FakeChunkStorage.floodSkylightFromAbove(fullSectionAbove);
            }
            skyLight[y] = inferredSection;
        }
        FakeChunk chunk = new FakeChunk(world, pos, chunkSections);
        class_2487 hightmapsTag = level.method_10562("Heightmaps");
        EnumSet<class_2902.class_2903> missingHightmapTypes = EnumSet.noneOf(class_2902.class_2903.class);
        for (class_2902.class_2903 type : chunk.method_12009().method_12160()) {
            String key = type.method_12605();
            if (hightmapsTag.method_10573(key, 12)) {
                chunk.method_12037(type, hightmapsTag.method_10565(key));
                continue;
            }
            missingHightmapTypes.add(type);
        }
        class_2902.method_16684((class_2791)chunk, missingHightmapTypes);
        if (!config.isNoBlockEntities()) {
            class_2499 blockEntitiesTag = level.method_10554("block_entities", 10);
            for (int i = 0; i < blockEntitiesTag.size(); ++i) {
                chunk.method_12042(blockEntitiesTag.method_10602(i));
            }
        }
        return () -> FakeChunkStorage.lambda$deserialize$5(world, chunkSections, pos, (class_2804[])blockLight, skyLight, chunk, config);
    }

    private static class_2804 floodSkylightFromAbove(class_2804 above) {
        if (above.method_12146()) {
            return new class_2804();
        }
        byte[] aboveBytes = above.method_12137();
        byte[] belowBytes = new byte[2048];
        for (int i = 0; i < 16; ++i) {
            System.arraycopy(aboveBytes, 0, belowBytes, i * 128, 128);
        }
        return new class_2804(belowBytes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void upgrade(class_5321<class_1937> worldKey, BiConsumer<Integer, Integer> progress) throws IOException {
        List chunks;
        Optional<class_5321> generatorKey = Optional.of((class_5321)class_2378.field_25097.method_29113((Object)class_2897.field_24769).orElseThrow());
        try (Stream<Path> stream = Files.list(this.directory);){
            chunks = stream.map(Path::getFileName).map(Path::toString).map(REGION_FILE_PATTERN::matcher).filter(Matcher::matches).map(it -> new RegionPos(Integer.parseInt(it.group(1)), Integer.parseInt(it.group(2)))).flatMap(RegionPos::getContainedChunks).collect(Collectors.toList());
        }
        AtomicInteger done = new AtomicInteger();
        AtomicInteger total = new AtomicInteger(chunks.size());
        progress.accept(done.get(), total.get());
        class_4698 io = (class_4698)this.method_39800();
        int workThreads = Math.max(1, Runtime.getRuntime().availableProcessors() - 2);
        ExecutorService workExecutor = Executors.newFixedThreadPool(workThreads, (ThreadFactory)new DefaultThreadFactory("bobby-upgrade-worker", true));
        try {
            for (class_1923 chunkPos : chunks) {
                workExecutor.submit(() -> {
                    class_2487 nbt;
                    try {
                        nbt = io.method_23700(chunkPos);
                    }
                    catch (IOException e) {
                        LOGGER.warn("Error reading chunk " + chunkPos.field_9181 + "/" + chunkPos.field_9180 + ":", (Throwable)e);
                        nbt = null;
                    }
                    if (nbt == null) {
                        progress.accept(done.get(), total.decrementAndGet());
                        return;
                    }
                    nbt = this.method_17907(worldKey, null, nbt, generatorKey);
                    io.method_23703(chunkPos, nbt).join();
                    progress.accept(done.incrementAndGet(), total.get());
                });
            }
        }
        finally {
            workExecutor.shutdown();
        }
        try {
            workExecutor.awaitTermination(Long.MAX_VALUE, TimeUnit.NANOSECONDS);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        progress.accept(done.get(), total.get());
    }

    private static void logRecoverableError(class_1923 chunkPos, int y, String message) {
        LOGGER.error("Recoverable errors when loading section [" + chunkPos.field_9181 + ", " + y + ", " + chunkPos.field_9180 + "]: " + message);
    }

    private static /* synthetic */ class_2818 lambda$deserialize$5(class_1937 world, class_2826[] chunkSections, class_1923 pos, class_2804[] blockLight, class_2804[] skyLight, FakeChunk chunk, BobbyConfig config) {
        boolean hasSkyLight = world.method_8597().method_12491();
        class_2802 chunkManager = world.method_8398();
        class_3568 lightingProvider = chunkManager.method_12130();
        ChunkLightProviderExt blockLightProvider = ChunkLightProviderExt.get(lightingProvider.method_15562(class_1944.field_9282));
        ChunkLightProviderExt skyLightProvider = ChunkLightProviderExt.get(lightingProvider.method_15562(class_1944.field_9284));
        for (int i = -1; i < chunkSections.length + 1; ++i) {
            int y = world.method_31604(i);
            if (blockLightProvider != null) {
                blockLightProvider.bobby_addSectionData(class_4076.method_18681((class_1923)pos, (int)y).method_18694(), blockLight[i + 1]);
            }
            if (skyLightProvider == null || !hasSkyLight) continue;
            skyLightProvider.bobby_addSectionData(class_4076.method_18681((class_1923)pos, (int)y).method_18694(), skyLight[i + 1]);
        }
        chunk.setTainted(config.isTaintFakeChunks());
        for (class_2338 blockPos : chunk.method_12021()) {
            chunk.method_8321(blockPos);
        }
        chunk.method_39792(true);
        return chunk;
    }

    static {
        for (int x = 0; x < 16; ++x) {
            for (int y = 0; y < 16; ++y) {
                for (int z = 0; z < 16; ++z) {
                    COMPLETELY_LIT.method_12145(x, y, z, 15);
                }
            }
        }
        BLOCK_CODEC = class_2841.method_38298((class_2359)class_2248.field_10651, (Codec)class_2680.field_24734, (class_2841.class_6563)class_2841.class_6563.field_34569, (Object)class_2246.field_10124.method_9564());
    }

    private record RegionPos(int x, int z) {
        public Stream<class_1923> getContainedChunks() {
            int baseX = this.x << 5;
            int baseZ = this.z << 5;
            class_1923[] result = new class_1923[1024];
            for (int x = 0; x < 32; ++x) {
                for (int z = 0; z < 32; ++z) {
                    result[x * 32 + z] = new class_1923(baseX + x, baseZ + z);
                }
            }
            return Stream.of(result);
        }
    }
}

